/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 13.20)
 *
 *  Oparte na znanym algorytmie i sugestiach wielu osb.
 *
 *  Ten kod moe by dowolnie uywany i modyfikowany,
 *  bez adnych ogranicze.
 */

#include <stdlib.h>
#include <math.h>

#define NSUM 25

#ifdef NOSTATS
double gaussrand()
#else
double gaussrand(mean, stdev)
double mean, stdev;
#endif
{
	double x = 0;
	int i;
	for(i = 0; i < NSUM; i++)
		x += (double)rand() / RAND_MAX;

	x -= NSUM / 2.0;
	x /= sqrt(NSUM / 12.0);

#ifdef NOSTATS
	return x;
#else
	return mean + stdev * x;
#endif
}
